Attribute VB_Name = "adt8960"
Option Explicit
'******************************Basic library functions****************************
Declare Function adt8960_initial Lib "adt8960.dll" () As Integer
'*****************************************************************************
'Function: initialize card
' return value> 0, that the number of 8960 cards. If 3, the following were available card numbers 0,1,2
'return value = 0, do not install the 8960 card shows
' return value <0, -1 port driver is not installed, -2 that PCI Bridge there is a fault.
'*****************************************************************************

Declare Function set_pulse_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer, ByVal dir_logic As Integer) As Integer
'*****************************************************************************
'Function: Set the output pulse of the working methods
' parameter:
'cardno Card
' axis axis number (1 - 6) 'value 0: Pulse + Pulse Mode 1: Pulse + direction method
' logic 0: positive logic pulse 1: negative logic pulse
'dir-logic 0: the direction of the output signal is logic 1: the direction of the negative logic output signals
' return value 0: the right 1: Error
' default mode: Pulse + direction, positive logic pulse and direction output signals are logic

'*****************************************************************************

Declare Function set_limit_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v1 As Integer, ByVal v2 As Integer, ByVal dir_logic As Integer) As Integer
'*****************************************************************************
'Function: set the positive and negative direction limit input signal nLMT mode
' parameter:
'cardno Card
' axis axis number (1 - 6)
'v1 0: valid 1 is limit: Limit is invalid
' v2 0: negative limit effective 1: Negative limit invalid
'logic 0: active low 1: high effective
' return value 0: the right 1: Error
'default mode is: is the effective limit the negative limit effective, low effective
'*****************************************************************************

Declare Function set_stop0_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'*****************************************************************************
'Function: Set stop0 input mode
' parameter:
'cardno Card
' axis axis number (1 - 6)
'v 0: valid 1: Effective
' logic 0: active low 1: high effective
'return value 0: the right 1: Error
'default mode: Invalid
'*****************************************************************************

Declare Function set_stop1_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'*****************************************************************************
'Function: Set stop1 input mode
' parameter:
'cardno Card
' axis axis number (1 - 6)
'v 0: valid 1: Effective
' logic 0: active low 1: high effective
'return value 0: the right 1: Error
'default mode: Invalid
'*****************************************************************************

Declare Function get_status Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
'*****************************************************************************
'Function: get the axis of the drive status
' parameter:
' cardno Card
'axis axis number (1 - 6)
' v-driven state pointer
'0: Drive end of the non-0: are drivers
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function get_inp_status Lib "adt8960.dll" (ByVal cardno As Integer, ByRef value As Integer) As Integer
'*****************************************************************************
'Function: get interpolation driving status
' parameter:
'cardno card number
' v interpolation state pointer
'0: interpolation end of the 1: is interpolation
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function set_acc Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal add As Long) As Integer
'************************************************* ****************************
'function: acceleration settings' parameters:
'cardno Card' axis axis number (1 - 6) 'Add range (1 - 64000)
' the actual acceleration value add * 125
'return value 0: the right 1: Error
'*****************************************************************************

Declare Function set_startv Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal startv As Long) As Integer
'*****************************************************************************
'Function: the initial speed setting' parameters:
'cardno Card' axis axis number (1 - 6) 'startv range (1-2M),
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function set_speed Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal speed As Long) As Integer
'*****************************************************************************
'Function: Drive speed setting' parameters: 'cardno Card
' axis axis number (1 - 6) 'speed range (1-2M)
' return value 0: the right 1: Error
'*****************************************************************************


Declare Function set_command_pos Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*****************************************************************************
'Function: logical location to set' parameters: 'cardno Card' axis axis number (1 - 6)
'value range (-2147483648 ~ +2147483647)' return value 0: the right 1: Error
'*****************************************************************************

Declare Function set_actual_pos Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*****************************************************************************
'Function: Set the actual location' parameter: 'cardno Card' axis axis number (1 - 6)
'value range (-2147483648 ~ +2147483647)
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function set_symmetry_speed Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************** Set acceleration ******************* *****
'function: to set the value of acceleration' parameter: 'cardno Card
' axis axis number (1 - 6) 'lspd off speed' hspd drive speed 'tacc acceleration time
' return value 0: the right 1: Error
'******************************************************************/

Declare Function get_command_pos Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'*****************************************************************************
'Function: get the axis of the logical location' parameter: 'cardno Card
' axis axis number (1 - 6) 'value logical location of the pointer
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function get_actual_pos Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'*****************************************************************************
'Function: get the axis of the actual location of the' parameters: 'cardno Card
' axis axis number (1 - 6) 'value the actual location of the pointer
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function get_speed Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef value As Long) As Integer
'*****************************************************************************
'Function: get the axis of the current drive speed' parameter: 'cardno Card
' axis axis number (1 - 6) 'value-driven speed of the current pointer
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function get_out Lib "adt8960.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'/*************************** Obtain the output state ****************** *********
'function: get the output status' parameter:' cardno card number 'number port number
' Returns: the current state of specified port, said parameter error -1
'******************************************************************/


Declare Function pmove Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*****************************************************************************
'Function: Quantitative drivers' cardno Card 'axis axis number (1 - 6)
' value output pulses (-268 435 455 ~ +268435455)
'> 0: positive direction driving <0: Negative direction drive
' return value 0: correct 1: Error
'*****************************************************************************

Declare Function continue_move Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal dir As Integer) As Integer
'*****************************************************************************
'Function:' uniaxial continuous drive 'parameter:' cardno Card
'axis axis number (1 - 6)' dir drive the direction of
'0: positive direction 1: Negative direction of movement
' return value 0: the right 1: Error
'***************************************************************/


Declare Function dec_stop Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'*****************************************************************************
'Function: Drive deceleration to stop' parameter: 'cardno Card' axis axis number (1 - 6)
'return value 0: the right 1: Error
'*****************************************************************************

Declare Function sudden_stop Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'*****************************************************************************
'Function: Drive to immediately stop' parameter: 'cardno Card' axis axis number (1 - 6)
'return value 0: the right 1: Error
'*****************************************************************************

Declare Function inp_move2 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'*****************************************************************************
'Function: 2-axis linear interpolation' parameters: 'cardno card number
' axis1, axis2 involved interpolation of axis No.
'pulse1, pulse2 moving relative distance (-8,388,608 ~ +8388607)
' return value 0: the right 1: Error
'*****************************************************************************

Declare Function inp_move3 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'*****************************************************************************
'Function: Three-axis linear interpolation' parameters: 'cardno card number
' axis1, axis2, axis3 involved interpolation of axis No.
'pulse1, pulse2, pulse3 moving relative distance (-8388608 ~ +8388607)
' return value 0: correct 1: Error
'*****************************************************************************

Declare Function inp_move4 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
'*****************************************************************************
'Function: Four-axis linear interpolation' parameters: 'cardno card number
' axis1, axis2, axis3, axis4 involved interpolation of axis No.
'pulse1, pulse2, pulse3, pulse4 XYZA four-axis movement of the relative distance (-8388608 ~ +8388607 )
'Return value 0: the right 1: Error

'*****************************************************************************

Declare Function inp_move5 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long) As Integer
'*****************************************************************************
'Function: five-axis linear interpolation' parameters: 'cardno card number
' axis1, axis2, axis3, axis4, axis5 involved interpolation of axis No.
'pulse1, pulse2, pulse3, pulse4, pulse5 five-axis movement relative distance (-8388608 ~ +8388607)
'return value 0: the right 1: Error
'*****************************************************************************

Declare Function inp_move6 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
'*****************************************************************************
'Function: 6-axis linear interpolation' parameters: 'cardno card number
' pulse1, pulse2, pulse3, pulse4, pulse5, pulse6
'XYZABC six-axis movement of the relative distance (-8388608 ~ +8388607)
' return value 0: the right 1: error
'*****************************************************************************


Declare Function read_bit Lib "adt8960.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'*****************************************************************************
'Function: read input' parameters: 'cardno card number' number input (0 - 31)
'return value 0: Low 1: High -1: Error

'*****************************************************************************

Declare Function write_bit Lib "adt8960.dll" (ByVal cardno As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'*****************************************************************************
'Function: Output' Parameters: 'cardno card number' number output point (0 - 15)
'value 0: Low 1: High' return value 0: the right 1: Error
'*****************************************************************************
Declare Function get_lib_version Lib "adt8960.dll" (ByVal cardno As Integer) As Integer
'/************** Features: Get the current library version **************
'return value of the hardware and the library version of the version number of the combination

'************************************************/

Declare Function get_hardware_ver Lib "adt8960.dll" (ByVal cardno As Integer) As Single
'*****************************************************************************
''Function: Get hardware version of the 'parameters:' cardno card number
'return value 256: the hardware first edition

'*****************************************************************************



Declare Function set_suddenstop_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
'*****************************************************************************
'Function: hardware stop mode is set to' parameters: 'cardno card number
' v 0: valid 1: Effective 'logic 0: active low 1: high effective
' return value 0: the right 1: Error
'hardware stop signal fixed J2 terminal board using the 33 pin (IN31)
'*****************************************************************************

Declare Function set_io_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal v1 As Integer, ByVal v2 As Integer) As Integer
'*************************** Set the delay time ***************** *************
'Function:' Set Delay Time 'parameter:
' v1 0: 8 points ahead is defined as the input 1: 8 points ahead is defined as the output of
'v2 0: 8 points behind the definition of the input 1: 8 points behind the output is defined as
'the return value 0: the right 1: Error
' Note: When the IO point when used as an output point and can also read input status
'*********************************************************************

Declare Function set_delay_time Lib "adt8960.dll" (ByVal cardno As Integer, ByVal time As Long) As Integer
'*****************************************************************************
'Function: set the delay time' parameter: 'cardno Card' time delay time
'return value 0: the right 1: Error' time units 1/8us
'*****************************************************************************

Declare Function get_delay_status Lib "adt8960.dll" (ByVal cardno As Integer) As Integer
'*****************************************************************************
'Function: get the state delay' parameter: 'cardno card number
' return value 0: delay the end of 1: delay ongoing
'********************* ************************************************** ******
'//***************************************** ****//
'/ / composite driver class / /
'//********************************* ************//
Declare Function symmetry_relative_move Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'********************************************************
'* Function: single-axis linear interpolation relative motion, the light of the current location, in order to speed up the quantitative move
' * Parameters: 'cardno - Card' axis --- Shaft No. 'pulse - pulse' lspd --- slow
'hspd --- High-speed 'tacc --- speed up the time (unit: seconds)
' vacc --- acceleration change rate 'mode --- accelerating mode (0: trapezoid, 1: S-type)
' return value 0: the right 1: Error
'*********************************************************/

Declare Function symmetry_absolute_move Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************ *********
'* Function: absolute motion axis linear interpolation, zero reference position to speed up the quantitative move
' * Parameters: 'cardno - Card' axis --- Shaft No. 'pulse - pulse 'lspd --- slow
' hspd --- high-speed 'tacc --- acceleration time (unit: seconds)
' vacc --- acceleration change rate 'mode --- accelerating mode (0: trapezoid, 1: S-type)
'return value 0: the right 1: Error
'**********************************************************/

Declare Function symmetry_relative_line2 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/**********************************************************
'* Function: 2-axis linear interpolation relative motion, the light of the current location, in order to speed up linear interpolation
' * Parameters:
'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' pulse1 - - Pulse 1
'pulse2 - Pulse 2
' lspd --- slow
'hspd --- high-speed
' tacc --- speed up the time (unit: seconds)
'vacc --- acceleration of the rate of change
' mode --- accelerating mode (0 : ladder, 1: S-type)
'return value 0: the right 1: Error
'***********************************************************/
Declare Function symmetry_absolute_line2 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'* Function: 2-axis linear interpolation of absolute motion, zero reference position to speed up linear interpolation
' * Parameters: 'cardno - Card' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' pulse1 - - Pulse 1
'pulse2 - Pulse 2
' lspd --- slow
'hspd --- high-speed
' tacc --- speed up the time (unit: seconds)
'vacc --- acceleration of the rate of change
' mode --- accelerating mode (0 : ladder, 1: S-type)
'return value 0: the right 1: Error
'************************************************************/

Declare Function symmetry_relative_line3 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/************************************************************
'* Function: Three-axis linear interpolation relative motion, the light of the current location, in order to speed up linear interpolation
' * Parameters: 'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' axis3 - - Shaft No. 3
'pulse1 - Pulse 1
' pulse2 - Pulse 2
'pulse3 - Pulse 3
' lspd --- slow
'hspd --- high-speed
' tacc --- speed up the time (unit: seconds)
'vacc- - acceleration of the rate of change
'mode --- accelerating mode (0: trapezoid, 1: S-type)
' return value 0: the right 1: Error
'***************************************************************/

Declare Function symmetry_absolute_line3 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/**************************************************************
'Function: linear interpolation axis absolute motion, zero reference position to speed up linear interpolation
' parameters: 'cardno - Card' axis1 --- Shaft No. 1 'axis2 --- Shaft No. 2
' axis3 --- Shaft No. 3 'pulse1 - Pulse 1' pulse2 - Pulse 2 'pulse3 - Pulse 3
' lspd --- slow 'hspd --- high-speed' tacc --- speed up the time (unit: seconds)
'vacc --- acceleration of the rate of change
'mode --- accelerating mode (0: trapezoid, 1: S-type)
' return value 0: the right 1: Error
'****************************************************************/

Declare Function symmetry_relative_line4 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/****************************************************************
'* Function: Four-axis linear interpolation relative motion, the light of the current location, in order to speed up linear interpolation
' * Parameters:
'cardno - Card
' axis1 --- Shaft No. 1
'axis2 --- Shaft No. 2
' axis3 - - Shaft No. 3
'axis4 --- shaft No. 4
' pulse1 - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'pulse4 - pulse 4
' lspd --- slow
'hspd --- high-speed
' tacc --- speed up the time (unit: seconds)
'vacc --- acceleration of the rate of change
' mode --- accelerating mode (0: trapezoid, 1: S-type)
'****************************************************************/


Declare Function symmetry_absolute_line4 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************************************************************
'* Function: Four-axis linear interpolation of absolute motion, zero reference position to acceleration and deceleration in a straight line interpolation
' * Parameters: 'cardno - Card' axis1 --- Shaft No. 1 'axis2 --- Shaft No. 2
' axis3 --- Shaft No. 3 'axis4 --- Shaft No. 4' pulse1 - Pulse 1 'pulse2 - Pulse 2
' pulse3 - Pulse 3 'pulse4 - pulse 4' lspd --- slow 'hspd --- High Speed
'tacc --- speed up the time (unit: seconds)' vacc --- acceleration of the rate of change
'mode --- accelerating mode (0: trapezoid, 1: S-type)
'****************************************************************/

Declare Function symmetry_relative_line5 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Axis linear interpolation relative motion ****************
'* Function: reference to the current location, to acceleration and deceleration in a straight line interpolation
'* Parameters:' cardno - Card 'axis1 --- Shaft No. 1' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3' axis4 --- Shaft No. 4 'axis5 --- Shaft No. 5 'pulse1 - Pulse 1
' pulse2 - Pulse 2 'pulse3 - Pulse 3' pulse4 - pulse 4 'pulse5 - Pulse 5' lspd --- slow
'hspd --- high-speed' tacc --- speed up the time (unit: seconds)
'vacc --- acceleration of the rate of change
' mode --- accelerating mode (0: trapezoid, 1: S-type)
'******************************************************/

Declare Function symmetry_absolute_line5 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Symmetry axis linear interpolation absolute motion ****************
'* Function: Zero reference position to symmetric acceleration and deceleration in a straight line interpolation
'* Parameters:' cardno - Card
'axis1 --- Shaft No. 1
' axis2 --- Shaft No. 2
'axis3 --- Shaft No. 3
' axis4 --- Shaft No. 4
'axis5 --- Shaft No. 5
' pulse1 - Pulse 1
'pulse2 - Pulse 2
' pulse3 - Pulse 3
'pulse4 - pulse 4
' pulse5 - Pulse 5
'lspd --- slow
' hspd --- High Speed
'tacc --- speed up the time (unit: seconds)
' vacc --- acceleration of the rate of change
'mode --- accelerating mode (0: trapezoid, 1: S-type)
'******************************************************/

Declare Function symmetry_relative_line6 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'/***************** Six-axis linear interpolation relative motion ****************
'* Function: reference to the current location, to acceleration and deceleration in a straight line interpolation
'* Parameters:' cardno - card number 'pulse1 - Pulse 1' pulse2 - Pulse 2 'pulse3 - Pulse 3
' pulse4 - pulse 4 'pulse5 - Pulse 5' pulse6 - Pulse 6 'lspd --- slow' hspd --- high-speed
'tacc --- acceleration time (unit: seconds)' vacc --- acceleration change rate
'mode --- speed mode (0: trapezoid, 1: S-type )
'******************************************************/

Declare Function symmetry_absolute_line6 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'***************** Six-axis symmetric linear interpolation absolute motion ****************
'* Function: Zero reference position symmetrical acceleration and deceleration in a straight line interpolation
'* Parameters:' cardno - card number 'pulse1 - Pulse 1' pulse2 - Pulse 2 'pulse3 - Pulse 3
' pulse4 - pulse 4
'pulse5 - Pulse 5
' pulse6 - - Pulse 6
'lspd --- slow
' hspd --- high-speed
'tacc --- speed up the time (unit: seconds)
' vacc --- acceleration of the rate of change
'mode --- accelerating mode (0: trapezoid, 1: S type)
'******************************************************/

'//----------------------------------------------------//
'//                   2008.10.6                        //
'//----------------------------------------------------//
Declare Function set_acac Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'/******************* Functions: plus / minus the rate of change speed settings ****************** **
'cardno Card' axis axis number 'value K value (1 - 65535)
' the actual rate of change 1000000 / k 'return value 0: the right 1: Error
'******************************************************************/

Declare Function set_ad_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer) As Integer
'/********************* Features: Add / decelerating way of setting ****************** ****
'cardno Card' axis axis number (1 - 4)
'mode 0: linear acceleration / deceleration 1: S curve acceleration / deceleration
' return value 0: the right 1: Error
'default mode: linear acceleration / deceleration
'******************************************************************/

Declare Function get_ad Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef ad As Long) As Integer
'/******************* Function: get the axis of the current acceleration *********************
'cardno Card' axis axis No. 'ad the current acceleration of the pointer
' return value 0: the correct one: Error
'data-driven acceleration of the units and the value is set as
'************** A ************************************************** ** /
'//-------------------------------------------- --------//
'/ / external signal driver / /
'//----------------------------- -----------------------//

Declare Function manual_continue Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/******************* Function: external signal continuous drive *********************
'cardno Card 'axis axis number' return value 0: the right 1: Error
'Note: (1) a continuous pulse, but the driver did not immediately need to wait until the external signal level changes
' (2) you can use the normal buttons, you can took over the wheel
'******************************************************************/

Declare Function manual_pmove Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/******************* Function: external signal quantitatively driven *********************
'cardno Card 'axis axis number' return value 0: the right 1: Error
'Note: (1) a quantitative pulse, but the driver did not immediately need to wait until the external signal level changes
' (2) you can use the normal buttons, you can took over the wheel

'******************************************************************/

Declare Function manual_disable Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/*********************** Close external signal drives enable ******************* ****
'function: Close external signal drives enable' parameter:
'cardno Card' axis axis number (1 - 6)
'return value 0: the right 1: Error
'*********** ************************************************** *****/
'//----------------------------------------- -----------//
'/ / location of latch / /
'//-------------------------- --------------------------//

Declare Function set_lock_position Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
'/**************************** Position latch set function *************** *******
'function: to set in place the signal function, lock all the axes of the logical location and the actual location of the
' parameters:
'axis-reference axis
' mode-latch mode | 0: Invalid
'| 1: Effective
' regi- Counter mode | 0: logical location
'| 1: actual position' logical-level signal | 0: rising edge
'| 1: falling
' return value 0: Correct 1: Error
'Description: Use the specified axis as the axis of the IN signal Trigger=
'*******************************************************************/

Declare Function get_lock_status Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef v As Integer) As Integer
'/************************* Latch operation for the state ***************** ******
'Function: get the status latch operations
' parameters:
' cardno Card
'axis axis number (1 - 6)
' v 0 | is not running latch operation
'1 | latch operation performed' return value 0: the right 1: Error
'Description: Use this function to capture whether the implementation of the latch position
'******************************************************************/

Declare Function get_lock_position Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef pos As Long) As Integer
'/************************** Get locked position ****************** ********
'features: access to the locked position' parameter: 'cardno Card
' axis axis number (1 - 6) 'pos latched position
' return value 0: the right 1: Error
'******************************************************************/

Declare Function clr_lock_status Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/************************** Clear lock ******************** ******
'Function: remove Lock' Parameters: 'cardno Card' axis axis number (1 - 6)
'return value 0: the right 1: Error
'************* ************************************************** *** /
'//------------------------------------------- ---------//
'/ / hardware cache / /
'//----------------------------- -----------------------//
Declare Function fifo_inp_move1 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal pulse1 As Long, ByVal speed As Long) As Integer
'/************************** Uniaxial cache ******************* *******
'function: single cache' parameter: 'cardno Card' axis1 axis number (1 - 6)
'pulse1 cache pulse' speed cache speed 'return value 0: the correct one: Error
' description : A total of 2048 buffer space, each occupied by three uniaxial instruction cache space, cache 682 instructions

'******************************************************************/

Declare Function fifo_inp_move2 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal speed As Long) As Integer
'/************************** Two axes cache ******************* *******
'feature: two-axle cache' parameter: 'cardno Card' axis1 axis number (1 - 6)
'axis2 axis number (1 - 6)' pulse1 cache pulses' pulse2 cache of pulses
'speed cache speed
' return value 0: the right 1: Error
'Description: A total of 2048 buffer space, each occupied by four single-axis instruction cache space, cache 512 instructions

'******************************************************************/

Declare Function fifo_inp_move3 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal speed As Long) As Integer
'/************************** Axis cache ******************* *******
'function: axis cache' parameter: 'cardno Card' axis1 axis number (1 - 6)
'axis2 axis number (1 - 6)' axis3 axis number (1 - 6) 'pulse1 cache The pulses
' pulse2 cache pulses' pulse3 cache pulses
' speed cache speed 'return value 0: Correct 1: Error
' Description: A total of 2048 buffer space, each occupied by five single-axis instruction cache space, instruction cache 409

'******************************************************************/

Declare Function fifo_inp_move4 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal speed As Long) As Integer
'/************************** Four-axis cache ******************* *******
'features: Four-axis cache' parameter: 'cardno Card' axis1 axis number (1 - 6)
'axis2 axis number (1 - 6)' axis3 axis number (1 - 6) 'axis4 axis No. (1 - 6)
'pulse1 cache pulses' pulse2 cache pulses' pulse3 cache pulses' pulse4 cache pulses
' speed cache speed
' return value 0: the right 1: Error
'Description: A total of 2048 buffer space occupied by each instruction cache 6 Single space, instruction cache 341

'******************************************************************/

Declare Function fifo_inp_move5 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal speed As Long) As Integer
'/************************** Axis cache ******************* *******
'feature: Five-axis cache' parameter: 'cardno Card' axis1 axis number (1 - 6)
'axis2 axis number (1 - 6)' axis3 axis number (1 - 6) 'axis4 axis No. (1 - 6)
'axis5 axis number (1 - 6)' pulse1 cache pulses' pulse2 cache pulses' pulse3 cache pulses
' pulse4 cache pulses' pulse5 cache pulses' speed cache speed
'return value 0: the right 1: Error
' Description: A total of 2048 buffer space occupied by each axis 7 instruction cache space, cache 292 instructions

'******************************************************************/

Declare Function fifo_inp_move6 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal speed As Long) As Integer
'/************************** Six-axis cache ******************* *******
'feature: six-axis cache' parameter: 'cardno Card' pulse1 cache pulses
'pulse2 cache pulses' pulse3 cache pulses 'pulse4 cache pulses' pulse5 cache of pulses
'pulse6 cache pulses' speed cache speed 'return value 0: the right 1: Error
' Description: A total of 2048 buffer space occupied by each axis 8 instruction cache space, cache 256 instructions

'******************************************************************/

Declare Function reset_fifo Lib "adt8960.dll" (ByVal cardno As Integer) As Integer
'/************************** Reset cache ******************* *******
'function: clear the cache' parameter: 'cardno card number
' return value 0: the right 1: Error
'******************************************************************/

Declare Function read_fifo_count Lib "adt8960.dll" (ByVal cardno As Integer, ByRef value As Integer) As Integer
'/************************** Read caching few ****************** ****
'function: the number of read cache and store instructions into the number of remaining non-implementation of
' parameters:
'cardno card number' return value 0: the right 1: Error
'******************************************************************/

Declare Function read_fifo_empty Lib "adt8960.dll" (ByVal cardno As Integer) As Integer
'/************************** Read cache state ****************** ****
'function: read cache is empty' parameter: 'cardno card number
' return value 0: non-empty 1: Empty
'******************************************************************/

Declare Function read_fifo_full Lib "adt8960.dll" (ByVal cardno As Integer) As Integer
'/************************** Read cache state ****************** ****
'function: read cache is full, full will no longer exist after the data
' parameter: 'cardno card number' return value 0: less than 1: Man
'********** ************************************************** ******/
'//**************************************** **********************************//
'/ / *********** ** ************* manual deceleration function / /
'/ / First need to set the manual deceleration mode / /
' / / When the manual deceleration mode of efficient, set manual deceleration point pos1 / /
'/ / set origin offset pos2 / /
'/ / set the manual deceleration point and the speed (low speed) endspeed / /
' / / manual deceleration movement: Movement to the deceleration point pos1 automatically slow down to endspeed run / /
'/ / to speed endspeed search origin signal, origin of the signal the need for external signal trigger (stop0 the low level trigger) / /
'/ / When the origin of the signal is triggered, the campaign immediately after the origin offset pos2 stop / /

'//**************************************************************************//
Declare Function set_dec_mode Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer) As Integer
'/************************** Set manual deceleration mode ****************** ********
'Function: set manual deceleration mode' parameter: 'cardno Card' axis axis number (1 - 6)
'mode manual deceleration mode 0 is invalid a valid' return value 0: the right 1: Error
'******************************************************************/

Declare Function set_dec_pos1 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/************************** Set manual deceleration point ****************** ********
'Function: set manual deceleration point
' parameter: 'cardno Card
' axis axis number (1 - 6)
'pos deceleration point
' returns the value 0: the right 1: Error
'description: to the deceleration points automatically slow down to a specific low-speed movement, looking for the origin of the trigger signal,
'If you do not find the trigger signal, has been movement at this rate will continue until the end of the exercise

'******************************************************************/

Declare Function set_dec_pos2 Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pos As Long) As Integer
'/************************** Specified offset **************** manual deceleration **********
'function: reduction surplus position' parameter: 'cardno Card' axis axis number (1 - 6)
'pos surplus position' return value 0: the right 1: Error
'Description: Movement of the offset the need for external trigger signal, trigger the low signal stop0
'******************************************************************/

Declare Function clr_dec_status Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'/************************** Clear manual deceleration ****************** ********
'function: the origin offset' parameters: 'cardno Card' axis axis number (1 - 6)
'return value 0: the right 1: Error
'******************************************************************/

Declare Function get_dec_status Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByRef sta As Integer) As Integer
'/************************** For manual deceleration ****************** ********
'features: access to manual deceleration' parameter: 'cardno Card' axis axis number (1 - 6)
'sta deceleration' 0: Searching for 'one: search is completed
' 2: The movement has stop, slow down point not found '3: did not meet the actual migration
' 4: Search deceleration point during servo off
'5: deceleration point has been found to offset movement is not in place (may be triggering limit, etc.)
' return value 0: the right 1: Error

'******************************************************************/

Declare Function set_end_speed Lib "adt8960.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal speed As Long) As Integer
'Function: trailing speed settings' cardno Card 'axis axis number (1 - 6)
' speed range (1-2M) 'return value 0: the right 1: Error
' Note: If the manual deceleration point pos1 not found after trigger signal (slow signal origin), has been movement will continue at this rate




Public Sub MyProc()

    DoEvents

End Sub

